#!/usr/bin/env python3
# Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
import sys
sys.path.append("code/slowfast")

"""Wrapper to train and test a video classification model."""
from slowfast.config.defaults import assert_and_infer_cfg
from slowfast.utils.misc import launch_job
from slowfast.utils.parser import load_config, parse_args

from train_finetune_net import train
from test_finetune_net import test

import os

def main():
    """
    Main function to spawn the train and test process.
    """
    os.environ['OPENBLAS_NUM_THREADS'] = '12'

    args = parse_args()
    cfg = load_config(args)
    cfg = assert_and_infer_cfg(cfg)

    # launch_job(cfg=cfg, init_method=args.init_method, func=train)
    launch_job(cfg=cfg, init_method=args.init_method, func=test)



if __name__ == "__main__":
    main()
